<?php
require_once '../../controller/QueueController.php';
$queueController = new QueueController();
$result = $queueController->getAllQueues();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PharmaEase</title>
    <link rel="stylesheet" href="style.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Days+One&family=Lexend:wght@100..900&family=Teko:wght@300..700&display=swap');
        
        /* Revert to previous design with wider spacing */
        .table-header {
            display: flex;
            color: white;
            padding: 12px;
            font-weight: bold;
            border-radius: 5px 5px 0 0;
        }

        .row {
            display: flex;
            padding: 12px;
            border-bottom: 1px solid #ddd;
            align-items: center;
        }

        .row:nth-child(even) {
            background-color: #f9f9f9;
        }

        .col-id {
            width: 80px;
            padding: 5px;
        }

        .col-queue {
            width: 130px;
            padding: 8px;
        }

        .col-name {
            width: 220px;
            padding: 8px;
        }

        .col-email {
            width: 220px;
            padding: 8px;
        }

        .queue-controls {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
            margin: 20px 0;
        }

        .queue-number {
            font-size: 3em;
            font-weight: bold;
            color: #4CAF50;
        }

        .queue-btn {
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            font-size: 12px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s;
        }

        .queue-btn:hover {
            background-color: #45a049;
        }

        .section-header {
            background-color: #4CAF50;
            color: white;
            padding: 15px;
            font-size: 1.2em;
            font-weight: bold;
            border-radius: 5px 5px 0 0;
            margin-bottom: 15px;
        }

        .completed-section, .right-section {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 20px;
            padding-bottom: 15px;
        }

        .announcements-section {
            margin-top: 20px;
        }

        .announcement-list {
            padding: 10px;
        }

        .announcement-item {
            padding: 12px;
            margin-bottom: 8px;
            background-color: #f5f5f5;
            border-radius: 4px;
            position: relative;
        }

        .announcement-item:before {
            content: "•";
            color: #4CAF50;
            font-weight: bold;
            display: inline-block;
            width: 1em;
            margin-left: -1em;
        }
    </style>
</head>

<body>
    <section id="homebg">
        <nav class="navbar">
            <div class="navbar-container">
                <a href="#" class="navbar-brand">
                    <img src="logo.png" alt="PharmaEase Logo">
                    <span>PharmaEase</span> </a>
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a href="home.php" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                        <a href="dashboard.php" class="nav-link">Dashboard</a>
                    </li>
                
                    <li class="nav-item">
                        <a href="index.php" class="nav-link">Logout</a>
                    </li>
                </ul>
            </div>
        </nav>
        <section id="welcome">
            <h1>Welcome to PharmaEase <br>
                A service you can trust</h1>
        </section>
        <section id="whitespace">
            <br><br><br><br><br><br><br><br>
            <br><br><br><br><br><br><br><br>
        </section>
        </section>
        <div class="container">
        <div class="dashboard-section">
        <h1 class="dashboard-title">Dashboard</h1>

        <div class="container">
        <div class="completed-section">
            <div class="section-header">QUEUE</div>
            <div class="table-header">
                <div class="col-id">ID</div>
                <div class="col-queue">Queue #</div>
                <div class="col-name">Name</div>
                <div class="col-email">Email</div>
            </div>
            <div class="table-rows">
                <?php
                if ($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        echo '<div class="row">';
                        echo '<div class="col-id">' . $row['ID'] . '</div>';
                        echo '<div class="col-queue">#' . str_pad($row['Queue #'], 3, '0', STR_PAD_LEFT) . '</div>';
                        echo '<div class="col-name">' . $row['Name'] . '</div>';
                        echo '<div class="col-email">' . $row['Email'] . '</div>';
                        echo '</div>';
                    }
                } else {
                    echo '<div class="row"><div class="col-id" colspan="4">No queue entries found</div></div>';
                }
                ?>
            </div>
        </div>

        <div class="right-section">
            <div class="queue-section">
                <div class="section-header">CURRENT QUEUE</div>
                <div class="queue-controls">
                    <div class="queue-number">
                        #<?php echo str_pad($queueController->getCurrentQueue(), 3, '0', STR_PAD_LEFT); ?>
                    </div>
                    <button class="queue-btn" onclick="updateQueue('increase')">Next</button>
                </div>
            </div>

            <div class="announcements-section">
                <div class="section-header">ANNOUNCEMENTS</div>
                <div class="announcement-list">
                    <div class="announcement-item">Low Stock of Cetirizine</div>
                    <div class="announcement-item">Meeting @ 2pm</div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function updateQueue(action) {
        const xhr = new XMLHttpRequest();
        xhr.open('POST', '../../controller/update_queue.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        
        xhr.onload = function() {
            if (xhr.status === 200) {
                try {
                    const response = JSON.parse(xhr.responseText);
                    
                    if (response.success) {
                        // Reload the page to show updated queue
                        location.reload();
                    } else {
                        console.error('Error updating queue:', response.message);
                        alert('Error: ' + response.message);
                    }
                } catch (e) {
                    console.error('Error parsing response:', xhr.responseText);
                    alert('Error processing response from server');
                }
            } else {
                console.error('Server returned error code:', xhr.status);
                alert('Server error. Please try again later.');
            }
        };
        
        xhr.onerror = function() {
            console.error('Request failed');
            alert('Request failed. Please check your network connection.');
        };
        
        xhr.send('action=' + action);
    }
</script>
</body>
</html>