<?php
session_start();
if (!isset($_SESSION['user_email'])) { // Or any other session variable that indicates a logged-in user
    header("Location: index.php"); // Redirect to login page
    exit();
}
require_once '../../model/users.php';

$userData = getUserData();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Profile - PharmaEase</title>
    <link rel="stylesheet" href="users.css">
    <link rel="stylesheet" href="navbar_styles.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Days+One&family=Lexend:wght@100..900&family=Teko:wght@300..700&display=swap');
    </style>
</head>

<body>

    <section id="homebg">
        <nav class="navbar">
            <div class="navbar-container">
                <a href="home.php" class="navbar-brand">
                    <img src="Frame 6.png" alt="PharmaEase Logo">
                    <span>PharmaEase</span>
                </a>
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a href="home.php" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                        <a href="cart.php" class="nav-link">Cart</a>
                    </li>
                    <li class="nav-item">
                        <a href="users.php" class="nav-link active">User</a>
                    </li>
                    <li class="nav-item">
                        <a href="../../controller/logout.php" class="nav-link">Logout</a>
                    </li>
                </ul>
            </div>
        </nav>

        <section id="whitespace">
            <br><br><br><br><br><br><br><br>
            <br><br><br><br><br><br><br><br>
        </section>

    </section>


    <section id="profile-section">
        <form action="update_profile.php" method="POST">
            <h2>Profile</h2>
            <div class="form-container">
                <div class="form-group">
                    <label for="full_name">Full Name</label>
                    <input type="text" id="full_name" name="full_name"
                        value="<?php echo htmlspecialchars($userData['full_name'] ?? ''); ?>" readonly>
                </div>
                <div class="form-group">
                    <label for="phone">Phone Number</label>
                    <input type="text" id="phone" name="phone"
                        value="<?php echo htmlspecialchars($userData['phone'] ?? ''); ?>" readonly>
                </div>
                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" id="email" name="email"
                        value="<?php echo htmlspecialchars($userData['email'] ?? ''); ?>" readonly>
                </div>
                <div class="form-group">
                    <label for="gender">Gender</label>
                    <input type="text" id="gender" name="gender" value="<?php echo htmlspecialchars($userData['gender'] ?? ''); ?>" readonly>
                </div>
                <div class="form-group">
                    <label for="address">Address</label>
                    <input type="text" id="address" name="address"
                        value="<?php echo htmlspecialchars($userData['address'] ?? ''); ?>" readonly>
                </div>
                <div class="form-group">
                    <label for="city">City</label>
                    <input type="text" id="city" name="city" value="<?php echo htmlspecialchars($userData['city'] ?? ''); ?>"
                        readonly>
                </div>
            </div>

            <div class="button-group">
                <button type="button" class="btn btn-history" id="history">History</button>
                <button type="submit" class="btn btn-update">Edit Profile</button>
            </div>
        </form>
    </section>

    <script>
        document.getElementById('history').addEventListener('click', function () {
            window.location.href = 'history.php';
        });
    </script>

</body>

</html>