<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include model to interact with database
require_once __DIR__ . '/../../model/users.php';

// Check if user is logged in
if (!isset($_SESSION['user_email'])) {
    header('Location: index.php');
    exit();
}

// Get order ID from URL parameter
$orderId = isset($_GET['order_id']) ? $_GET['order_id'] : null;

if (!$orderId) {
    header('Location: cart.php?error=no_order_found');
    exit();
}

// Create model instance and fetch order details from database
$userModel = new User();
$orderDetails = $userModel->getOrderDetailsById($orderId);

// If order not found or doesn't belong to current user, redirect
if (!$orderDetails || ($orderDetails['user_email'] !== $_SESSION['user_email'])) {
    $userModel->closeConnection();
    header('Location: cart.php?error=invalid_order');
    exit();
}

// Get queue number from database result
$queueNumber = isset($orderDetails['queue_number']) ? $orderDetails['queue_number'] : 'N/A';

$userModel->closeConnection();

// Include navigation if available
if (file_exists('topbar.php')) {
    include_once 'topbar.php';
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Success</title>
    <link rel="stylesheet" href="navbar_styles.css">
    <link rel="stylesheet" href="cart.css">
    <style>
        .order-success-container {
            max-width: 800px;
            margin: 30px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .order-header {
            background-color: #4a7c8a;
            color: white;
            padding: 15px;
            border-radius: 6px 6px 0 0;
            text-align: center;
            margin-bottom: 20px;
        }
        .queue-display {
            background-color: #e3f2fd;
            padding: 20px;
            border-radius: 6px;
            text-align: center;
            margin-bottom: 20px;
        }
        .queue-number {
            font-size: 48px;
            font-weight: bold;
            color: #4a7c8a;
            margin: 10px 0;
        }
        .action-buttons {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 10px;
            margin-top: 20px;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            text-decoration: none;
            text-align: center;
            transition: background-color 0.3s ease;
        }
        .btn-primary {
            background-color: #4a7c8a;
            color: white;
        }
        .btn-secondary {
            background-color: #6c757d;
            color: white;
        }
        .btn-info {
            background-color: #17a2b8;
            color: white;
        }
        .btn:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body>
    <div class="order-success-container">
        <div class="order-header">
            <h2>Order Completed Successfully!</h2>
        </div>
        
        <div class="queue-display">
            <h3>Your Queue Number</h3>
            <div class="queue-number"><?php echo $queueNumber; ?></div>
            <p>Please keep this number handy. Your order will be processed according to this queue number.</p>
        </div>
        
        <div style="text-align: center;">
            <p>Thank you for your order. Your order has been successfully placed and is now being processed.</p>
            
            <div class="action-buttons">
                <a href="../../controller/generateOrderPDF.php?order_id=<?php echo $orderId; ?>" class="btn btn-primary" target="_blank">
                    View Receipt PDF
                </a>
                
                <a href="cart.php" class="btn btn-secondary">
                    Back to Cart
                </a>
                
                <a href="history.php" class="btn btn-info">
                    View Order History
                </a>
            </div>
        </div>
    </div>

    <script>
        // Cart is now handled server-side, no need to clear localStorage
        console.log('Order completed successfully');
    </script>
</body>
</html> 