<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
if (!isset($_SESSION['user_email'])) {
    header("Location: index.php");
    exit();
}

// Include the model to access database functions
require_once '../../model/users.php';

$userId = $_SESSION['user_id'] ?? 0;
$userModel = new User();

// Get order history from database
$orderHistory = $userModel->getOrderHistory($userId);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>PharmaEase - Order History</title>
    <link rel="stylesheet" href="navbar_styles.css" />
    <link rel="stylesheet" href="history.css" />
</head>

<body>
    <section id="homebg">
        <nav class="navbar">
            <div class="navbar-container">
                <a href="home.php" class="navbar-brand">
                    <img src="Frame 6.png" alt="PharmaEase Logo">
                    <span>PharmaEase</span>
                </a>
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a href="home.php" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                        <a href="cart.php" class="nav-link">Cart</a>
                    </li>
                    <li class="nav-item">
                        <a href="users.php" class="nav-link">User</a>
                    </li>
                    <li class="nav-item">
                        <a href="../../controller/logout.php" class="nav-link">Logout</a>
                    </li>
                </ul>
            </div>
        </nav>
    </section>

    <div id="header-bg">
        <h2>Order History</h2>
    </div>
    
    <section id="history-section">
        <div class="history-container">
            <?php if (empty($orderHistory)): ?>
                <div class="no-orders">You don't have any orders yet.</div>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>Order Date</th>
                            <th>Items</th>
                            <th>Total Amount</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($orderHistory as $orderId => $order): ?>
                            <?php 
                                // Calculate total amount for this order
                                $orderTotal = 0;
                                foreach ($order['items'] as $item) {
                                    $orderTotal += $item['price'] * $item['quantity'];
                                }
                                
                                // Determine status based on queue number
                                $isCompleted = $order['queue_number'] === NULL;
                            ?>
                            <tr>
                                <td class="order-date"><?php echo date('M d, Y h:i A', strtotime($order['date'])); ?></td>
                                <td>
                                    <?php 
                                        $itemNames = array_map(function($item) {
                                            return $item['product_name'] . ' (x' . $item['quantity'] . ')';
                                        }, $order['items']);
                                        echo implode(', ', $itemNames);
                                    ?>
                                </td>
                                <td>₱<?php echo number_format($orderTotal, 2); ?></td>
                                <td>
                                    <?php if ($isCompleted): ?>
                                        <span class="status-badge status-completed">Completed</span>
                                    <?php else: ?>
                                        <div>
                                            <span class="queue-number">Queue: <?php echo $order['queue_number']; ?></span>
                                            <span class="status-badge status-pending">Pending</span>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="../../controller/generateOrderPDF.php?order_id=<?php echo $orderId; ?>" target="_blank" class="view-pdf-btn">View Receipt</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </section>
</body>

</html>