<?php
if (session_status() == PHP_SESSION_NONE) { // Ensure session is started
    session_start();
}

// Check if the admin is logged in, otherwise redirect to login page
if (!isset($_SESSION['admin_email'])) { // <-- USE YOUR ACTUAL ADMIN SESSION VARIABLE HERE
    header("Location: ../user/index.php"); // Or your admin login page
    exit();
}

// Prevent caching of this page
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Pragma: no-cache");

require_once '../../controller/QueueController.php';

// --- Handle Queue Update Action (Next button) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'increase') {
    $queueUpdateController = new QueueController();
    $updateResult = $queueUpdateController->handleQueueUpdate();
    // Redirect to GET to prevent re-posting on refresh and to show updated queue
    header('Location: home.php' . (isset($updateResult['success']) && !$updateResult['success'] ? '?queue_error=' . urlencode($updateResult['message']) : '') );
    exit();
}
// --- End Handle Queue Update ---

$queueController = new QueueController();
$allQueueEntries = $queueController->getAllQueues(); // Fetch from database
$currentAdminQueueNumber = $queueController->getCurrentQueue(); // Fetch from database
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PharmaEase</title>
    <link rel="stylesheet" href="style.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Days+One&family=Lexend:wght@100..900&family=Teko:wght@300..700&display=swap');
        
    
        .table-header {
            display: flex;
            color: white;
            padding: 12px;
            font-weight: bold;
            border-radius: 5px 5px 0 0;
        }

        .row {
            display: flex;
            padding: 12px;
            border-bottom: 1px solid #ddd;
            align-items: center;
        }

        .row:nth-child(even) {
            background-color: #f9f9f9;
        }

        .col-id {
            width: 130px;
            padding: 8px;
        }

        .col-queue {
            width: 130px;
            padding: 8px;
        }

        .col-name {
            width: 220px;
            padding: 8px;
        }

        .col-email {
            width: 220px;
            padding: 8px;
        }

        .col-view {
            width: 130px;
            padding: 8px;
        }

        .queue-controls {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
            margin: 20px 0;
        }

        .queue-number {
            font-size: 4em;
            font-weight: bold;
            color: gray;
        }

        .queue-btn {
            background-color: #ADDCE1;
            color: black;
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            font-size: 12px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s;
             font-weight: bold;
        }

        .queue-btn:hover {
            background-color: #4a7c8a;
        }

        .view-btn {
            background-color: #4a7c8a;
            color: white;
            padding: 6px 10px;
            border-radius: 4px;
            text-decoration: none;
            font-size: 14px;
            transition: background-color 0.3s, transform 0.2s;
            display: inline-block;
        }

        .view-btn:hover {
            background-color: #3a6b76;
            transform: translateY(-2px);
        }

        .section-header {
            background-color: #4a7c8a;
            color: white;
            padding: 15px;
            font-size: 1.2em;
            font-weight: bold;
            border-radius: 5px 5px 0 0;
            margin-bottom: 15px;
        }
        .navbar {
  background: linear-gradient(to right, #6d6d6d, #8d8d8d); /* Gradient background */
  opacity: 0.85; /* Slightly more visible */
  padding: 1rem;
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2); /* Stronger shadow for depth */
  height: 150px;
  overflow: hidden;
  backdrop-filter: blur(10px); /* Glassmorphism effect */
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.navbar img {
  position: relative;
  top: 0.4em;
  right: 14em;
  width: 100%;
  height: 100%;
  object-fit: contain; /* Ensure proper image fit */
}

.navbar-container {
  display: flex;
  flex-wrap: wrap;
  justify-content: space-between;
  align-items: center;
  max-width: 1100px;
  margin: auto;
  position: relative;
  top: 50%;
  left: 15%;
  transform: translate(0%, -60%);
}

.navbar-brand {
  display: flex;
  align-items: center;
  text-decoration: none;
  color: #fff;
  font-weight: 500;
  margin-left: -280px;
}

.navbar-brand span {
  color: #ffffff;
  text-align: left;
  font-family: "DaysOne-Regular", sans-serif;
  font-size: 50px;
  font-weight: 700;
  position: relative;
  top: 15px;
  right: 4em;
  text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3); /* Subtle shadow */
}

.navbar-nav {
  list-style: none;
  margin: 0;
  padding: 0;
  display: flex;
}

.nav-item {
  margin-left: 20px;
}

.nav-link {
  text-decoration: none;
  color: #ffffff;
  text-align: left;
  font-family: "Ramabhadra-Regular", sans-serif;
  font-size: 24px;
  font-weight: 400;
  position: relative;
  top: 50%;
  width: 83px;
  padding: 0.5rem 1rem;
  border-radius: 8px;
  transition: all 0.3s ease;
  background: transparent;
}

.nav-link:hover, .nav-link.active {
  background-color: rgba(0, 123, 255, 0.2);
  color: #ffffff;
  box-shadow: 0 0 8px rgba(0, 123, 255, 0.6);
}


a.nav-link {
  font-size: 25px;
}


    </style>
</head>

<body>
    <section id="homebg">
              <nav class="navbar">
            <div class="navbar-container">
                <a href="#" class="navbar-brand">
                    <img src="logo.png" alt="PharmaEase Logo">
                    <span>PharmaEase</span> </a>
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a href="home.php" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                        <a href="dashboard.php" class="nav-link">Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a href="manage_products.php" class="nav-link">Products</a>
                    </li>
                    <li class="nav-item">
                        <a href="../../controller/logout.php" class="nav-link">Logout</a>
                    </li>
                </ul>
            </div>
        </nav>
        <section id="welcome">
            <h1>Welcome to PharmaEase <br>
                A service you can trust</h1>
        </section>
        <section id="whitespace">
            <br><br><br><br><br><br><br><br>
            <br><br><br><br><br><br><br><br>
        </section>
        </section>
        <div class="container">
        <div class="dashboard-section">
        <h1 class="dashboard-title">Dashboard</h1>

        <div class="container">
        <div class="completed-section">
            <div class="table-header">
                <div class="col-id">Order ID</div>
                <div class="col-queue">Queue #</div>
                <div class="col-name">Full Name</div>
                <div class="col-email">Email</div>
                <div class="col-view">View Order</div>
            </div>
            <div class="table-rows">
                <?php
                if ($allQueueEntries && $allQueueEntries->num_rows > 0) {
                    while ($q_row = $allQueueEntries->fetch_assoc()) {
                        echo '<div class="row">';
                        echo '<div class="col-id">' . htmlspecialchars($q_row['order_id']) . '</div>';
                        echo '<div class="col-queue">#' . htmlspecialchars(str_pad($q_row['queue_number'], 3, '0', STR_PAD_LEFT)) . '</div>';
                        echo '<div class="col-name">' . htmlspecialchars($q_row['full_name']) . '</div>';
                        echo '<div class="col-email">' . htmlspecialchars($q_row['email']) . '</div>';
                        echo '<div class="col-view"><a href="../../controller/generateOrderPDF.php?order_id=' . $q_row['order_id'] . '" class="view-btn" target="_blank">View PDF</a></div>';
                        echo '</div>';
                    }
                } else {
                    echo '<div class="row"><div style="text-align:center; width:100%;">No active queue entries found</div></div>';
                }
                ?>
            </div>
        </div>

        <div class="right-section">
            <div class="queue-section">
                <div class="section-header">CURRENT QUEUE</div>
                <div class="queue-controls">
                    <div class="queue-number">
                        <?php 
                        echo '#' . htmlspecialchars(str_pad($currentAdminQueueNumber, 3, '0', STR_PAD_LEFT));
                        ?>
                    </div>
                    <form method="POST" action="home.php" style="display: inline;">
                         <input type="hidden" name="action" value="increase">
                         <button type="submit" class="queue-btn">Next</button>
                    </form>
                </div>
            </div>

            <div class="announcements-section">
                <div class="section-header">ANNOUNCEMENTS</div>
                <div class="announcement-list">
                    <div class="announcement-item">Low Stock of Cetirizine</div>
                    <div class="announcement-item">Meeting @ 2pm</div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Remove the old updateQueue JavaScript function if it exists
    // function updateQueue(action) { ... }
</script>
</body>
</html>