<?php
require_once '../../controller/process.php'; // Changed from ../controller/

// Get user ID from URL
$userId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Initialize processor
$processor = new UserProcessor();
$user = $processor->getUserById($userId); // Fetches user_id, full_name, email, status, gender, phone, address, city

if (!$user) {
    header('Location: dashboard.php'); // Stays dashboard.php (now relative to view/admin/)
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit User</title>
    <link rel="stylesheet" href="edit.css"> <!-- Changed from href="edit.css" (was relative to model/) -->
</head>
<body>
    <div class="container">
        <h1>Edit User</h1>
        
        <div id="form-block">
            <form method="POST" action="../../controller/process.php?action=update"> <!-- Changed from ../controller/ -->
                <input type="hidden" name="id" value="<?= htmlspecialchars($user['user_id']) ?>"> <!-- Changed to user_id -->
                
                <div id="form-block-half">
                    <label for="full_name">Full Name</label> <!-- Changed to full_name -->
                    <input type="text" id="full_name" name="full_name" value="<?= htmlspecialchars($user['full_name']) ?>" required>
                    
                    <label for="email">Email</label> <!-- Changed to email -->
                    <input type="email" id="email" name="email" value="<?= htmlspecialchars($user['email']) ?>" required>

                    <label for="phone">Phone Number</label> <!-- Added phone -->
                    <input type="text" id="phone" name="phone" value="<?= htmlspecialchars($user['phone'] ?? '') ?>" required>

                    <label for="address">Address</label> <!-- Added address -->
                    <input type="text" id="address" name="address" value="<?= htmlspecialchars($user['address'] ?? '') ?>" required>

                    <label for="city">City</label> <!-- Added city -->
                    <input type="text" id="city" name="city" value="<?= htmlspecialchars($user['city'] ?? '') ?>" required>
                </div>
                
                <div id="form-block-half">
                    <label for="gender">Gender</label> <!-- Changed to gender -->
                    <select id="gender" name="gender" required>
                        <!-- Assuming database stores lowercase, ensure consistency -->
                        <option value="male" <?= strtolower($user['gender']) == 'male' ? 'selected' : '' ?>>Male</option>
                        <option value="female" <?= strtolower($user['gender']) == 'female' ? 'selected' : '' ?>>Female</option>
                        <option value="other" <?= strtolower($user['gender']) == 'other' ? 'selected' : '' ?>>Other</option>
                    </select>
                    
                    <label for="status">Status</label> <!-- Changed to status -->
                    <select id="status" name="status" required>
                        <!-- Ensure these values match what your application expects/stores -->
                        <option value="active" <?= strtolower($user['status'] ?? '') == 'active' ? 'selected' : '' ?>>Active</option>
                        <option value="inactive" <?= strtolower($user['status'] ?? '') == 'inactive' ? 'selected' : '' ?>>Inactive</option>
                        <option value="pending" <?= strtolower($user['status'] ?? '') == 'pending' ? 'selected' : '' ?>>Pending</option>
                        <option value="Regular" <?= ($user['status'] ?? '') == 'Regular' ? 'selected' : '' ?>>Regular</option>
                        <option value="PWD" <?= ($user['status'] ?? '') == 'PWD' ? 'selected' : '' ?>>PWD</option>
                    </select>
                </div>
                
                <div id="button-block">
                    <input type="submit" value="Update">
                    <a href="dashboard.php" class="cancel-btn">Cancel</a> <!-- Changed from ../view/admin/dashboard.php -->
                </div>
            </form>
        </div>
    </div>
</body>
</html> 