<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Check if the admin is logged in, otherwise redirect to login page
if (!isset($_SESSION['admin_email'])) {
    header("Location: ../user/index.php");
    exit();
}

// Prevent caching of this page
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Pragma: no-cache");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Product</title>
    <link rel="stylesheet" href="dashboard.css"> <!-- or a specific add_product.css -->
    <link rel="stylesheet" href="add_product_styles.css">
    <link rel="stylesheet" href="../user/navbar_styles.css">
</head>
<body>
    <nav class="navbar">
         <div class="navbar-container">
            <a href="#" class="navbar-brand"><img src="logo.png" alt="PharmaEase Logo"><span>PharmaEase</span></a>
            <ul class="navbar-nav">
                <li class="nav-item"><a href="home.php" class="nav-link">Home</a></li>
                <li class="nav-item"><a href="dashboard.php" class="nav-link">Dashboard</a></li>
                <li class="nav-item"><a href="manage_products.php" class="nav-link">Products</a></li>
                <li class="nav-item"><a href="../../controller/logout.php" class="nav-link">Logout</a></li>
            </ul>
        </div>
    </nav>
    <div class="container">
        <h1>Add New Product</h1>
        <div class="form-container">
            <form action="../../controller/add_edit_product_controller.php" method="POST">
                <input type="hidden" name="action" value="add">
                <div>
                    <label for="name">Product Name:</label>
                    <input type="text" id="name" name="name" required>
                </div>
                <div>
                    <label for="price">Price:</label>
                    <input type="number" id="price" name="price" step="0.01" required>
                </div>
                <div>
                    <label for="description">Description:</label>
                    <textarea id="description" name="description" rows="4" required></textarea>
                </div>
                <div>
                    <label for="stock">Stock Quantity:</label>
                    <input type="number" id="stock" name="stock" required min="0">
                </div>
                <div>
                    <label for="image_path">Image Path:</label>
                    <input type="text" id="image_path" name="image_path" placeholder="e.g., images/products/item.jpg">
                </div>
                <button type="submit">Add Product</button>
            </form>
        </div>
    </div>
</body>
</html> 