<?php
// Ensure session is started before trying to manipulate it
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Unset specific known session variables
unset($_SESSION['user_email']);
unset($_SESSION['admin_email']);
unset($_SESSION['role']);
unset($_SESSION['id']);
// You can add other specific session variables your app uses here

// Unset all of the session variables.
$_SESSION = array();

// If it's desired to kill the session, also delete the session cookie.
// Note: This will destroy the session, and not just the session data!
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Finally, destroy the session.
session_destroy();

// Redirect to login page
// Ensure no output before this header call
header("Location: ../view/user/index.php");
exit;
?>