<?php
// Start output buffering to prevent any premature output
ob_start();

require('fpdf.php');
require_once __DIR__ . '/../model/users.php';

// It's good practice to define a custom PDF class if you need a specific header/footer
// For now, assuming default FPDF behavior or that a similar custom PDF class like in generateOrderPDF.php might be intended.

class MyUserListPDF extends FPDF {
    function Header() {
        // Custom header for user list PDF
        $this->SetFont('Arial', 'B', 16);
        $this->Cell(0, 10, 'User Records', 0, 1, 'C');
        $this->Ln(5);
    }
    function Footer() {
        // Custom footer
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Page ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }
}


try {
    // Create User object to access its methods
    $userModel = new User();
    $users = $userModel->getPDFUsers(); // This now returns user_id, full_name, email, gender, status
    $userModel->closeConnection(); // Close connection after fetching data

    // PDF Generation Code
    $pdf = new FPDF(); // Or use MyUserListPDF() if defined above
    
    $pdf->AddPage();
    // $pdf->Header(); // FPDF::Header() is protected and called automatically by AddPage.
                     // Remove this direct call. If a custom header is needed, extend FPDF.

    $pdf->SetFont('Arial', 'B', 12);
    if (!empty($users)) {
        // Add table headers - Match the data from getPDFUsers()
        $pdf->SetFont('Arial', 'B', 10); // Adjusted font size for headers
        $pdf->Cell(20, 10, 'User ID', 1, 0, 'C');
        $pdf->Cell(60, 10, 'Full Name', 1, 0, 'L'); // Increased width for full_name
        $pdf->Cell(70, 10, 'Email', 1, 0, 'L');    // Increased width for email
        $pdf->Cell(20, 10, 'Gender', 1, 0, 'C');
        $pdf->Cell(25, 10, 'Status', 1, 1, 'C'); // Added Ln() by changing last 0 to 1
        
        $pdf->SetFont('Arial', '', 10);
        
        foreach ($users as $row) {
            // The $row from getPDFUsers() should now have keys: user_id, full_name, email, gender, status
            // No need for cleaning keys if the model returns them correctly.
            $pdf->Cell(20, 10, $row['user_id'], 1, 0, 'C');
            $pdf->Cell(60, 10, $row['full_name'], 1, 0, 'L');
            $pdf->Cell(70, 10, $row['email'], 1, 0, 'L');
            $pdf->Cell(20, 10, $row['gender'], 1, 0, 'C');
            $pdf->Cell(25, 10, $row['status'], 1, 1, 'C'); // Added Ln()
        }
        $pdf->Ln(5); // Add some space before the footer line
        $pdf->Cell(0, 10, '---------------------- Nothing Follows ----------------------', 0, 1, 'C');
    } else {
        $pdf->Cell(0, 10, 'No user records found', 0, 1, 'C');
    }

    ob_end_clean();
    $pdf->Output('I', 'User_Records_' . date('Y-m-d') . '.pdf');

} catch (Exception $e) {
    if (ob_get_length()) ob_end_clean(); // Ensure buffer is cleaned on error too
    die('Error generating PDF: ' . $e->getMessage());
}
?>