<?php
require_once 'process.php'; // Defines $currentQueueNumber, $currentUserName, and potentially sets $_SESSION['last_order_id']

// Determine the link for the PDF button
$pdfLink = "#"; // Default if no order_id is available
if (isset($_SESSION['last_order_id'])) {
    $pdfLink = 'generateOrderPDF.php?order_id=' . $_SESSION['last_order_id'];
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Queue Display</title> <!-- Changed title -->
    <link rel="stylesheet" href="generate.css">
    <link href='https://fonts.googleapis.com/css?family=Ramabhadra' rel='stylesheet'>
    </head>
<body>
<nav class="navbar">
    <div class="navbar-container">
        <a href="#" class="navbar-brand">
            <img src="logo.png" alt="PharmaEase Logo">
            <span>PharmaEase</span> </a>
        <ul class="navbar-nav">
            <li class="nav-item">
                <a href="../view/user/home.php" class="nav-link">Home</a>
            </li>
            <li class="nav-item">
                <a href="../view/user/users.php" class="nav-link">Profile</a>
            </li>
            <li class="nav-item">
                <a href="../view/user/index.php" class="nav-link">Logout</a>
            </li>
        </ul>
    </div>
</nav>
<div class="card">
    <img src="logo.png" class="pharmacy-icon" alt="Pharmacy Logo">
    <div class="number">#<?php echo str_pad($currentQueueNumber, 3, '0', STR_PAD_LEFT); ?></div>
    <div class="name"><?php echo $currentUserName; ?></div>
    <div class="button-container">
        <!-- Updated the href to be dynamic based on session last_order_id -->
        <a class="button view-pdf" href="<?php echo $pdfLink; ?>" id="viewPdfButton" <?php if ($pdfLink === "#") echo 'onclick="alert(\'No recent order found to generate PDF.\'); return false;"'; ?>>View Receipt PDF</a>
    </div>
</div>

<!-- Removed JavaScript that dynamically POSTs to generateOrderPDF.php -->
<!-- The button now directly links using order_id if available -->

</body>
</html>
