<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// If admin is already logged in, redirect to admin home
if (isset($_SESSION['role']) && $_SESSION['role'] === 'Admin') {
    header("Location: home.php"); 
    exit();
}
?>
<!DOCTYPE html>
<html>

<head>
    <title>Log-in</title>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="custom.css?<?php echo time(); ?>">
</head>

<body>
    <br><br><br><br><br><br><br><br><br><br>
    <div id="login-block">
        <h2>Please login</h2>
        <form method="POST" action="../../controller/process.php" name="login">
            <div>
                <input type="email" class="input" required name="email" placeholder="Valid E-mail" required />
            </div>
            <div>
                <input type="password" class="input" required name="password" placeholder="Password" required />
            </div>
            <div>
                <select name="user_role" id="roleSelector" class="input" required>
                    <option value="User">User</option>
                    <option value="Admin">Admin</option>
                </select>
                <p>Don't have an account? <a href="register.php">Register here</a></p>
            </div>
            <div style="margin-top: 50px;">
                <button type="submit">Submit</button>
            </div>
        </form>
    </div>
</body>

</html>