<?php
require_once 'process.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate Queue Display</title>
    <link rel="stylesheet" href="generate.css">
    <link href='https://fonts.googleapis.com/css?family=Ramabhadra' rel='stylesheet'>
    </head>
<body>
<nav class="navbar">
                <div class="navbar-container">
                    <a href="#" class="navbar-brand">
                        <img src="logo.png" alt="PharmaEase Logo">
                        <span>PharmaEase</span> </a>
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a href="../view/user/home.php" class="nav-link">Home</a>
                        </li>
                        <li class="nav-item">
                            <a href="../view/user/users.php" class="nav-link">Profile</a>
                        </li>
                        <li class="nav-item">
                            <a href="../view/user/index.php" class="nav-link">Logout</a>
                        </li>
                    </ul>
                </div>
</nav>
<div class="card">
    <img src="logo.png" class="pharmacy-icon" alt="Pharmacy Logo">
    <div class="number">#<?php echo str_pad($currentQueueNumber, 3, '0', STR_PAD_LEFT); ?></div>
    <div class="name"><?php echo $currentUserName; ?></div>
    <div class="button-container">
        <a class="button view-pdf" href="generateOrderPDF.php" id="viewPdfButton">View Pdf</a>
    </div>
</div>

<script>
// Make the PHP variable $cartJsonForPdf available to JavaScript
const cartJsonFromServer = <?php echo isset($cartJsonForPdf) ? $cartJsonForPdf : '[]'; ?>;

document.addEventListener('DOMContentLoaded', function() {
    const viewPdfButton = document.getElementById('viewPdfButton');
    if (viewPdfButton) {
        viewPdfButton.addEventListener('click', function(event) {
            event.preventDefault(); 

            let cartDataForPDF = [];
            if (cartJsonFromServer && cartJsonFromServer.length > 0) {
                // Use cart data passed from server (via session from checkout)
                cartDataForPDF = cartJsonFromServer;
            } else {
                // Fallback (though likely empty after checkout logic)
                // console.warn('Cart data from server was empty, trying localStorage as fallback for PDF.');
                // cartDataForPDF = JSON.parse(localStorage.getItem('cart')) || []; 
                // Decided to rely on server-passed data primarily. If it's not there, PDF will be empty.
            }

            const queueNumberElement = document.querySelector('.card .number');
            const userNameElement = document.querySelector('.card .name');
            const queueNumber = queueNumberElement ? queueNumberElement.textContent.trim() : 'N/A';
            const userName = userNameElement ? userNameElement.textContent.trim() : 'N/A';

            const form = document.createElement('form');
            form.method = 'POST';
            form.action = 'generateOrderPDF.php';
            form.style.display = 'none';

            const cartInput = document.createElement('input');
            cartInput.type = 'hidden';
            cartInput.name = 'cart_items_json';
            // Use cartDataForPDF which prioritizes server-passed data
            cartInput.value = JSON.stringify(cartDataForPDF); 
            form.appendChild(cartInput);

            const queueInput = document.createElement('input');
            queueInput.type = 'hidden';
            queueInput.name = 'queue_number';
            queueInput.value = queueNumber;
            form.appendChild(queueInput);

            const nameInput = document.createElement('input');
            nameInput.type = 'hidden';
            nameInput.name = 'user_name';
            nameInput.value = userName;
            form.appendChild(nameInput);

            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        });
    }
});
</script>
</body>
</html>
