<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Check if the admin is logged in, otherwise redirect to login page
if (!isset($_SESSION['admin_email'])) { // <-- USE YOUR ACTUAL ADMIN SESSION VARIABLE HERE
    header("Location: ../user/index.php"); // Or your admin login page
    exit();
}

// Prevent caching of this page
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Pragma: no-cache");

require_once '../../model/users.php'; // Contains User class

$product_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$product = null;

if ($product_id > 0) {
    $userModel = new User();
    $product = $userModel->getProductById($product_id);
    $userModel->closeConnection();
}

if (!$product) {
    $_SESSION['product_error_message'] = 'Product not found or invalid ID.';
    header("Location: manage_products.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Product</title>
    <link rel="stylesheet" href="dashboard.css"> <!-- or a specific edit_product.css -->
    <link rel="stylesheet" href="edit_product_styles.css">
    <link rel="stylesheet" href="../user/navbar_styles.css">
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <a href="#" class="navbar-brand"><img src="logo.png" alt="PharmaEase Logo"><span>PharmaEase</span></a>
            <ul class="navbar-nav">
                <li class="nav-item"><a href="home.php" class="nav-link">Home</a></li>
                <li class="nav-item"><a href="dashboard.php" class="nav-link">Dashboard</a></li>
                <li class="nav-item"><a href="manage_products.php" class="nav-link">Products</a></li>
                <li class="nav-item"><a href="../../controller/logout.php" class="nav-link">Logout</a></li>
            </ul>
        </div>
    </nav>
    <div class="container">
        <h1>Edit Product (ID: <?php echo htmlspecialchars($product['ID']); ?>)</h1>
        <div class="form-container">
            <form action="../../controller/add_edit_product_controller.php" method="POST">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($product['ID']); ?>">
                <div>
                    <label for="name">Product Name:</label>
                    <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($product['Name']); ?>" required>
                </div>
                <div>
                    <label for="price">Price:</label>
                    <input type="number" id="price" name="price" step="0.01" value="<?php echo htmlspecialchars($product['Price']); ?>" required>
                </div>
                <div>
                    <label for="description">Description:</label>
                    <textarea id="description" name="description" rows="4" required><?php echo htmlspecialchars($product['Description']); ?></textarea>
                </div>
                <div>
                    <label for="imagePath">Image Filename (e.g., product.jpg):</label>
                    <input type="text" id="imagePath" name="imagePath" value="<?php echo htmlspecialchars(isset($product['ImagePath']) ? $product['ImagePath'] : ''); ?>">
                </div>
                <button type="submit">Update Product</button>
            </form>
        </div>
    </div>
</body>
</html> 