<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Admin') {
    header("Location: ../view/user/index.php"); 
    exit();
}

require_once '../model/users.php'; // Contains User class

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id > 0) {
    $userModel = new User();
    if ($userModel->deleteProduct($id)) {
        $_SESSION['product_success_message'] = 'Product deleted successfully.';
    } else {
        $_SESSION['product_error_message'] = 'Failed to delete product.';
    }
    $userModel->closeConnection();
} else {
    $_SESSION['product_error_message'] = 'Invalid product ID for deletion.';
}

header("Location: ../view/admin/manage_products.php");
exit();
?>